/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import com.google.common.base.Predicate;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomRegisters;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.reflection.block.BlockReflection;
import noppes.npcs.util.IPermission;
import noppes.npcs.util.Util;

public class CustomBlock
extends BlockInterface
implements IPermission,
ICustomElement {
    public NBTTagCompound nbtData;
    public AxisAlignedBB field_185505_j = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public AxisAlignedBB EAST_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public AxisAlignedBB SOUTH_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public AxisAlignedBB WEST_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private EnumBlockRenderType renderType = EnumBlockRenderType.MODEL;
    public PropertyDirection FACING;
    public PropertyInteger INT;
    public PropertyBool BO;

    public static EnumBlockRenderType getNbtRenderType(String name) {
        while (name.contains(" ")) {
            name = name.replace(" ", "_");
        }
        switch (name.toLowerCase()) {
            case "invisible": {
                return EnumBlockRenderType.INVISIBLE;
            }
            case "entityblock_animated": {
                return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
            }
        }
        return EnumBlockRenderType.MODEL;
    }

    public static SoundType getNbtSoundType(String soundName) {
        switch (soundName.toLowerCase()) {
            case "wood": {
                return SoundType.field_185848_a;
            }
            case "ground": {
                return SoundType.field_185849_b;
            }
            case "plant": {
                return SoundType.field_185850_c;
            }
            case "metal": {
                return SoundType.field_185852_e;
            }
            case "glass": {
                return SoundType.field_185853_f;
            }
            case "cloth": {
                return SoundType.field_185854_g;
            }
            case "sand": {
                return SoundType.field_185855_h;
            }
            case "snow": {
                return SoundType.field_185856_i;
            }
            case "ladder": {
                return SoundType.field_185857_j;
            }
            case "anvil": {
                return SoundType.field_185858_k;
            }
            case "slime": {
                return SoundType.field_185859_l;
            }
        }
        return SoundType.field_185851_d;
    }

    public CustomBlock(Material material, NBTTagCompound nbtBlock) {
        super(material);
        this.nbtData = nbtBlock;
        this.setName("custom_" + nbtBlock.func_74779_i("RegistryName"));
        this.field_149790_y = true;
        this.field_149762_H = SoundType.field_185851_d;
        this.field_149763_I = 1.0f;
        this.field_149786_r = this.field_149787_q ? 255 : 0;
        this.field_149785_s = !this.field_149764_J.func_76228_b();
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        if (nbtBlock.func_150297_b("Hardness", 5)) {
            this.func_149711_c(nbtBlock.func_74760_g("Hardness"));
        }
        if (nbtBlock.func_150297_b("Resistance", 5)) {
            this.func_149752_b(nbtBlock.func_74760_g("Resistance"));
        }
        if (nbtBlock.func_150297_b("LightLevel", 5)) {
            this.func_149715_a(nbtBlock.func_74760_g("LightLevel"));
        }
        if (nbtBlock.func_150297_b("BlockRenderType", 8)) {
            this.renderType = CustomBlock.getNbtRenderType(nbtBlock.func_74779_i("BlockRenderType"));
            this.func_149672_a(CustomBlock.getNbtSoundType(nbtBlock.func_74779_i("SoundType")));
            this.setAABB(nbtBlock.func_150295_c("AABB", 6));
        }
        this.BO = null;
        this.INT = null;
        this.FACING = null;
        if (nbtBlock.func_150297_b("Property", 10)) {
            BlockReflection.setBlockState((Block)this, this.func_180661_e());
            NBTTagCompound nbtProperty = nbtBlock.func_74775_l("Property");
            switch (nbtProperty.func_74771_c("Type")) {
                case 1: {
                    this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.BO, (Comparable)Boolean.valueOf(false)));
                    break;
                }
                case 3: {
                    this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.INT, (Comparable)Integer.valueOf(0)));
                    break;
                }
                case 4: {
                    this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.FACING, (Comparable)EnumFacing.NORTH));
                }
            }
        }
        this.func_149647_a(CustomRegisters.tabBlocks);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        if (this.nbtData != null && this.nbtData.func_150297_b("Property", 10)) {
            NBTTagCompound nbtProperty = this.nbtData.func_74775_l("Property");
            switch (nbtProperty.func_74771_c("Type")) {
                case 1: {
                    this.BO = PropertyBool.func_177716_a((String)nbtProperty.func_74779_i("Name"));
                    return new BlockStateContainer((Block)this, new IProperty[]{this.BO});
                }
                case 3: {
                    this.INT = PropertyInteger.func_177719_a((String)nbtProperty.func_74779_i("Name"), (int)nbtProperty.func_74762_e("Min"), (int)nbtProperty.func_74762_e("Max"));
                    return new BlockStateContainer((Block)this, new IProperty[]{this.INT});
                }
                case 4: {
                    this.FACING = PropertyDirection.func_177712_a((String)nbtProperty.func_74779_i("Name"), (Predicate)EnumFacing.Plane.HORIZONTAL);
                    return new BlockStateContainer((Block)this, new IProperty[]{this.FACING});
                }
            }
        }
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        String name = "";
        if (this.nbtData != null && this.nbtData.func_150297_b("BlockLayer", 8)) {
            name = this.nbtData.func_74779_i("BlockLayer");
        }
        while (name.contains(" ")) {
            name = name.replace(" ", "_");
        }
        switch (name.toLowerCase()) {
            case "cutout": {
                return BlockRenderLayer.CUTOUT;
            }
            case "cutout_mipped": {
                return BlockRenderLayer.CUTOUT_MIPPED;
            }
            case "translucent": {
                return BlockRenderLayer.TRANSLUCENT;
            }
        }
        return BlockRenderLayer.SOLID;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        if (this.FACING != null) {
            EnumFacing v = (EnumFacing)state.func_177229_b((IProperty)this.FACING);
            if (v == EnumFacing.EAST) {
                return this.EAST_BLOCK_AABB;
            }
            if (v == EnumFacing.SOUTH) {
                return this.SOUTH_BLOCK_AABB;
            }
            if (v == EnumFacing.WEST) {
                return this.WEST_BLOCK_AABB;
            }
        }
        return this.field_185505_j;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        if (this.nbtData != null && this.nbtData.func_74767_n("IsPassable")) {
            return field_185506_k;
        }
        if (this.FACING != null) {
            EnumFacing v = (EnumFacing)blockState.func_177229_b((IProperty)this.FACING);
            if (v == EnumFacing.NORTH) {
                return this.field_185505_j;
            }
            if (v == EnumFacing.EAST) {
                return this.EAST_BLOCK_AABB;
            }
            if (v == EnumFacing.SOUTH) {
                return this.SOUTH_BLOCK_AABB;
            }
            if (v == EnumFacing.WEST) {
                return this.WEST_BLOCK_AABB;
            }
        }
        return blockState.func_185900_c(worldIn, pos);
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        if (this.FACING != null) {
            return ((EnumFacing)state.func_177229_b((IProperty)this.FACING)).func_176745_a();
        }
        return super.func_176201_c(state);
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return this.renderType;
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        if (this.FACING != null) {
            return this.func_176223_P().func_177226_a((IProperty)this.FACING, (Comparable)placer.func_174811_aO().func_176734_d());
        }
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (this.FACING != null) {
            EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
            if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
                enumfacing = EnumFacing.NORTH;
            }
            return state.func_177226_a((IProperty)this.FACING, (Comparable)enumfacing);
        }
        if (this.INT != null) {
            return state.func_177226_a((IProperty)this.INT, (Comparable)Integer.valueOf(meta));
        }
        if (this.BO != null) {
            return state.func_177226_a((IProperty)this.BO, (Comparable)Boolean.valueOf(meta != 0));
        }
        return state;
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab != CustomRegisters.tabBlocks && tab != CreativeTabs.field_78027_g) {
            return;
        }
        if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
            return;
        }
        items.add((Object)new ItemStack((Block)this));
        if (tab == CustomRegisters.tabBlocks) {
            Util.instance.sort(items);
        }
    }

    public boolean hasProperty() {
        return this.BO != null || this.INT != null || this.FACING != null;
    }

    public boolean func_149716_u() {
        return false;
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return true;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return this.nbtData == null || !this.nbtData.func_74764_b("IsFullCube") || this.nbtData.func_74767_n("IsFullCube");
    }

    public boolean isLadder(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        return this.nbtData.func_74767_n("IsLadder");
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return this.nbtData == null || !this.nbtData.func_74764_b("IsOpaqueCube") || this.nbtData.func_74767_n("IsOpaqueCube");
    }

    public boolean func_176205_b(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        if (this.nbtData == null || !this.nbtData.func_150297_b("IsPassable", 3)) {
            return !this.field_149764_J.func_76230_c();
        }
        return this.nbtData.func_74767_n("IsPassable");
    }

    public void func_176213_c(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (worldIn.field_72995_K || this.FACING == null) {
            return;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
        IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
        IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)this.FACING);
        if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
            enumfacing = EnumFacing.SOUTH;
        } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
            enumfacing = EnumFacing.NORTH;
        } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
            enumfacing = EnumFacing.EAST;
        } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
            enumfacing = EnumFacing.WEST;
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)this.FACING, (Comparable)enumfacing), 2);
    }

    public void func_180633_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        if (this.FACING != null) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)this.FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        }
    }

    private void setAABB(NBTTagList tagList) {
        if (tagList == null || tagList.func_74745_c() == 0) {
            return;
        }
        double[] v = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        for (int i = 0; i < 6; ++i) {
            double s;
            double d = s = i < 3 ? 0.0 : 1.0;
            if (i < tagList.func_74745_c()) {
                s = tagList.func_150309_d(i);
            }
            v[i] = s;
        }
        this.field_185505_j = new AxisAlignedBB(v[0], v[1], v[2], v[3], v[4], v[5]);
        this.WEST_BLOCK_AABB = new AxisAlignedBB(v[2], v[1], 1.0 - v[3], v[5], v[4], 1.0 - v[0]);
        this.SOUTH_BLOCK_AABB = new AxisAlignedBB(1.0 - v[3], v[1], 1.0 - v[5], 1.0 - v[0], v[4], 1.0 - v[2]);
        this.EAST_BLOCK_AABB = new AxisAlignedBB(1.0 - v[5], v[1], v[0], 1.0 - v[2], v[4], v[3]);
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, @Nonnull Mirror mirrorIn) {
        if (this.FACING != null) {
            return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)this.FACING)));
        }
        return super.func_185471_a(state, mirrorIn);
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, @Nonnull Rotation rot) {
        if (this.FACING != null) {
            return state.func_177226_a((IProperty)this.FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)this.FACING)));
        }
        return super.func_185499_a(state, rot);
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("BlockType", 1)) {
            return this.nbtData.func_74771_c("BlockType");
        }
        return 0;
    }
}

